﻿'________________________________________________________________________________________
'
'DatabaseTable class v2.00 created 2008 by Matthew Dean of DeMontfort University mjdean@dmu.ac.uk
'this code is free to use/modify so long as full credit is given to the original author i.e. me!
'________________________________________________________________________________________
'revision history
'######################################################
'19th May 2009
'the code now insists on four parameters
'
'DatabaseName the name of the database file to be used
'SQL a valid SQL statement
'PNo the MarketPlace registered PNumber, this may be left blank if the code
' is not used within the MarketPlace enter #PN to auto enter your P number
'Password this is the valid MarketPlace password for the above p number
' the password may be left blank if not used in the MarketPlace enter #PW to auto enter your password
'if the class is used within the MarketPlace then a valid PNo/Password combination 
'must be used
'
'
'the code now throws exceptions when an error occurs
'these should give more information as to what has gone wrong
'
'I have changed the names of the properties to reflect database concepts
'eg records and fields
'######################################################
Imports Microsoft.VisualBasic
Imports System.Data.OleDb
Imports System.Data



Public Class DatabaseTable

    'declare a connection object
    Private mNewConnection As OleDbConnection
    'declare a data adapter
    Private mDataAdapter As OleDbDataAdapter
    'declare data table member variable
    Private mTableData As New DataTable
    'declare a data row object for use as blank record
    Private mARow As DataRow

    Public Function Count() As Integer
        Return mTableData.Rows.Count
    End Function

    Public ReadOnly Property RecordNumber(ByVal Index As Integer) As DataRow
        Get
            'return the data table member variable
            Try
                Return mTableData.Rows(Index)
            Catch
                Throw New SystemException("The record index number " & Index & " does not exist!")
                Return Nothing
            End Try
        End Get
    End Property

    Public Sub New(ByVal DatabaseName As String, ByVal SQL As String, ByVal PNumber As String, ByVal UserPassword As String)
        Call OpenDatabase(DatabaseName, "", SQL)
    End Sub


    Private Sub OpenDatabase(ByVal DatabaseName As String, ByVal PNumber As String, ByVal SQL As String)
        'declare a new command builder
        Dim CB As OleDbCommandBuilder
        'declare a variable to store the application path
        Dim DbPath As String = System.AppDomain.CurrentDomain.BaseDirectory & "App_Data\"
        'this is the connection string to an Access 2003 file uncomment as reguired
        Dim ConnectionString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & DbPath & PNumber & DatabaseName & ";Persist Security Info=False"
        'this is the connection string for Office 2007
        'Dim ConnectionString As String = "Provider=Microsoft.ACE.OLEDB.12.0;Data Source=" & DbPath & PNumber & DatabaseName & ";Persist Security Info=False"
        'opens the connection object based on the connection string
        mNewConnection = New OleDbConnection(ConnectionString)
        Try
            'open the connection
            mNewConnection.Open()
        Catch ex As Exception
            Throw New SystemException("The database file '" & DatabaseName & "' could not be opened")
        End Try
        'connect the data adapter to the connection object using the specified sql
        mDataAdapter = New OleDb.OleDbDataAdapter(SQL, mNewConnection)
        'initialise the select command of the data adapter
        mDataAdapter.SelectCommand = New OleDbCommand(SQL, mNewConnection)
        'initialise the command builder to initialis the other commands of the data adapter
        CB = New OleDbCommandBuilder(mDataAdapter)
        Try
            'populate the datatable via the data adapter 
            mDataAdapter.Fill(mTableData)
        Catch ex As Exception
            Throw New SystemException("The SQL statement '" & SQL & "' contains errors.")
        End Try
        'take a copy of the record structure
        mARow = mTableData.NewRow
        'close the connection
        mNewConnection.Close()
    End Sub

    Private Function GetDataTable(ByVal TableName As String) As DataTable
        'declare a new Data table
        Dim DT As New DataTable
        Dim SQL As String
        'declare a new command builder
        Dim CB As OleDbCommandBuilder
        SQL = "select * from " & TableName
        'connect the data adapter to the connection object using the specified sql
        mDataAdapter = New OleDb.OleDbDataAdapter(SQL, mNewConnection)
        'initilaise the select command of the data adapter
        mDataAdapter.SelectCommand = New OleDbCommand(SQL, mNewConnection)
        'ise the command builder to initialis the other commands of the data adapter
        CB = New OleDbCommandBuilder(mDataAdapter)
        'populate the datatable via the data adapter 
        mDataAdapter.Fill(DT)
        Return DT
    End Function

    Public Sub AddNewRecord()
        'add the new record to the datatable
        mTableData.Rows.Add(mARow)
        'create a new blank record
        mARow = mTableData.NewRow
    End Sub

    Public Sub SaveChanges()
        'save the changes to the database file
        mDataAdapter.Update(mTableData)
    End Sub

    Public Function GetFields() As DataRow
        Dim ARow As DataRow
        ARow = mTableData.NewRow
        Return ARow
    End Function

    Public ReadOnly Property NewRecord() As DataRow
        Get
            Return mARow
        End Get
    End Property

    Public Sub RemoveRecord(ByVal Index As Integer)
        Me.RecordNumber(Index).Delete()
    End Sub

End Class



